import os
import sys
sys.path.append(os.getcwd())
import utils.config as config
from pypower.case9 import case9
from pypower.case118 import case118
from pypower.case57 import case57
from pypower.case30 import case30
from pypower.case300 import case300
from pypower.ext2int import ext2int1
from generate_opf.case2000 import pglib_opf_case2000_goc
import numpy as np
import math
import scipy.io as sio


def case_generation():

    if config.Nbus == 9:
        mpc = case9()
    elif config.Nbus == 30:
        mpc = case30()
    elif config.Nbus == 57:
        mpc = case57()
    elif config.Nbus == 118:    
        mpc = case118()
    elif config.Nbus == 300:
        mpc = case300()
    elif config.Nbus == 2000:
        mpc = pglib_opf_case2000_goc()
    else:
        raise ValueError(f"Unsupported Nbus value: {config.Nbus}. Supported values are 9, 30, 57, 118, 300, and 2000.")
    
    config.bus = mpc['bus']

    config.gen = mpc['gen']

    config.branch = mpc['branch']

    config.baseMVA = mpc['baseMVA']
    _,config.bus,config.gen,config.branch = ext2int1(config.bus,config.gen, config.branch)
    config.gencost = mpc['gencost']


    config.bus_slack = np.where(config.bus[:, 1] == 3)
    config.bus_slack = np.squeeze(config.bus_slack)
    config.bus_slack_VA = config.bus[config.bus_slack, 8]  


    config.idxPg = np.squeeze(np.where(config.gen[:, 8] >= 0), axis=0)
    config.idxQg = np.squeeze(np.where(config.gen[:, 3] >= 0), axis=0)
    config.bus_Pg = config.gen[config.idxPg, 0].astype(int)
    config.bus_Qg = config.gen[config.idxQg, 0].astype(int)


    config.VmUb = config.bus[:,11]
    config.VmLb = config.bus[:,12]

    config.PG_Upbound = config.gen[config.idxPg, 8] / config.baseMVA
    config.PG_Lowbound = config.gen[config.idxPg, 9] / config.baseMVA
    config.QG_Upbound = config.gen[config.idxQg, 3] / config.baseMVA
    config.QG_Lowbound = config.gen[config.idxQg, 4] / config.baseMVA

    config.VA_Upbound = config.branch[:, 12]
    config.VA_Lowbound = config.branch[:, 11]


    config.gen_num = config.gen.shape[0]
    
    config.output_channels = config.bus.shape[0]*2-1

if __name__ == '__main__':
    case_generation()

